import { Sparkles, Mail, Phone, MapPin, Clock } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <Sparkles size={28} strokeWidth={2} className="footer-logo-icon" />
              <h2 className="footer-logo-text">WellnessHub</h2>
            </div>
            <p className="footer-description">
              Профессиональные спа-процедуры. 
              Релаксация и омоложение.
            </p>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={18} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={18} strokeWidth={2} />
                <a href="mailto:info@wellnesshub.ru">info@wellnesshub.ru</a>
              </li>
              <li>
                <MapPin size={18} strokeWidth={2} />
                <span>г. Москва, ул. Релаксационная, д. 12</span>
              </li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Услуги</h3>
            <ul className="footer-links">
              <li><a href="#">Массаж</a></li>
              <li><a href="#">Пилинг</a></li>
              <li><a href="#">Обёртывание</a></li>
              <li><a href="#">Ароматерапия</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Режим работы</h3>
            <ul className="footer-links">
              <li>
                <Clock size={16} strokeWidth={2} />
                <span>Пн-Вс: 9:00 - 22:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 WellnessHub. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

